const mailerService = require('../../src/services/mailerService');

const sendEmail = async (req, res) => {
    const { to, subject, text, html} = req.body;

    console.log('Enviando correo...');  

    try {
        const info = await mailerService.sendMail(to, subject, text, html);
        console.log('Correo enviado:', info);
        res.status(200).json({ message: 'Correo enviado exitosamente', messageId: info.messageId });
    } catch (error) {
        console.error('Error al enviar el correo:', error);
        res.status(500).json({ error: 'Error al enviar el correo', details: error.message });
    }
};

module.exports = { sendEmail };
